/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.jdbc.DbJdbcCondition;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class DbJdbcExpression
implements Serializable {
    private static ResourceBundle strings = ResourceBundle.getBundle("ibm.nways.jdm.database.jdbc.DbJdbcResources");
    public static final int AND = 0;
    public static final int OR = 1;
    private static final int FIRST_OPERATOR = 0;
    private static final int LAST_OPERATOR = 1;
    protected Vector conditions = new Vector();
    protected Vector operators = new Vector();

    public DbJdbcExpression(DbJdbcCondition dbJdbcCondition) {
        this.conditions.addElement(dbJdbcCondition);
    }

    public void setAdditionalCondition(DbJdbcCondition dbJdbcCondition, int n) throws IllegalArgumentException {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.conditions.addElement(dbJdbcCondition);
        this.operators.addElement(new Integer(n));
    }

    public static String getOperatorString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = strings.getString("AND");
                break;
            }
            case 1: {
                string = strings.getString("OR");
                break;
            }
        }
        return string;
    }

    public static Vector getAllOperators() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n <= 1) {
            vector.addElement(strings.getString(DbJdbcExpression.getOperatorString(n)));
            ++n;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.conditions.size();
        if (n > 1) {
            stringBuffer.append("(");
        }
        int n2 = 0;
        while (n2 < n) {
            DbJdbcCondition dbJdbcCondition = (DbJdbcCondition)this.conditions.elementAt(n2);
            stringBuffer.append(dbJdbcCondition.toString());
            if (n2 + 1 < n) {
                int n3 = (Integer)this.operators.elementAt(n2);
                switch (n3) {
                    case 0: {
                        stringBuffer.append(" AND ");
                        break;
                    }
                    case 1: {
                        stringBuffer.append(" OR ");
                        break;
                    }
                }
            }
            ++n2;
        }
        if (n > 1) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

